% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_shinytest2.R
\name{run_shinytest2_ptest}
\alias{run_shinytest2_ptest}
\title{Run the performance test based on a single commit using shinytest2}
\usage{
run_shinytest2_ptest(
  commit,
  project_path,
  app_dir,
  shinytest2_dir,
  tests_pattern,
  use_renv,
  renv_prompt,
  n_rep,
  debug
)
}
\arguments{
\item{commit}{A commit hash code or a branch's name}

\item{project_path}{The path to the project}

\item{app_dir}{The path to the application root}

\item{shinytest2_dir}{The directory with tests recorded by shinytest2}

\item{tests_pattern}{shinytest2 files pattern. E.g. 'performance'. If it is NULL,
all the content will be used}

\item{use_renv}{In case it is set as TRUE, package will try to apply
renv::restore() in all branches. Otherwise, the current loaded list of
packages will be used in all branches.}

\item{renv_prompt}{Prompt the user before taking any action?}

\item{n_rep}{Number of replications desired}

\item{debug}{Logical. TRUE to display all the system messages on runtime}
}
\value{
Return a \code{data.frame} with the collected performance time
}
\description{
Run the performance test based on a single commit using shinytest2
}
