% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{genDataDensity}
\alias{genDataDensity}
\title{Generate data from a density defined by a vector of integers}
\usage{
genDataDensity(n, dataDist, varname, uselimits = FALSE, id = "id")
}
\arguments{
\item{n}{Number of samples to draw from the density.}

\item{dataDist}{Vector that defines the desired density}

\item{varname}{Name of variable name}

\item{uselimits}{Indicator to use minimum and maximum of input data vector as 
limits for sampling. Defaults to FALSE, in which case a smoothed density that
extends beyond the limits is used.}

\item{id}{A string specifying the field that serves as the record id. The
default field is "id".}
}
\value{
A data table with the generated data
}
\description{
Data are generated from an a density defined by a vector of integers
}
\examples{
data_dist <- data_dist <- c(1, 2, 2, 3, 4, 4, 4, 5, 6, 6, 7, 7, 7, 8, 9, 10, 10)

genDataDensity(500, data_dist, varname = "x1", id = "id")
genDataDensity(500, data_dist, varname = "x1", uselimits = TRUE, id = "id")
}
\concept{generate_data}
