% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_choices.R
\name{simulate_choices}
\alias{simulate_choices}
\title{Simulate choices based on a data.frame with a design and respondents}
\usage{
simulate_choices(
  data,
  utility,
  setspp,
  bcoeff,
  decisiongroups = c(0, 1),
  manipulations = list(),
  preprocess_function = NULL
)
}
\arguments{
\item{data}{a dataframe that includes a design repeated for the number of observations}

\item{utility}{a list with the utility functions, one utility function for each alternatives}

\item{setspp}{an integer, the number of choice sets per person}

\item{bcoeff}{List of initial coefficients for the utility function. List content/length can vary based on application. I ideally begins (but does not have to) with b and need be the same as those entered in the utility functions}

\item{decisiongroups}{A vector showing how decision groups are numerically distributed}

\item{manipulations}{A variable to alter terms of the utility functions examples may be applying a factor or applying changes to terms selectively for different groups}

\item{preprocess_function}{= NULL You can supply a function that reads in external data (e.g. GIS coordinates) that will be merged with the simulated dataset. Make sure the the function outputs a data.frame that has a variable called ID which is used for matching.}
}
\value{
a data.frame that includes simulated choices and a design
}
\description{
Simulate choices based on a data.frame with a design and respondents
}
\examples{
example_df <- data.frame(
  ID = rep(1:100, each = 4),
  price = rep(c(10, 10, 20, 20), 100),
  quality = rep(c(1, 2, 1, 2), 100)
)

beta <- list(
  bprice   = -0.2,
  bquality =  0.8
)

ut <- list(
  u1 = list(
    v1 = V.1 ~ bprice * price + bquality * quality,
    v2 = V.2 ~ 0
  )
)
simulate_choices(example_df, ut, setspp = 4, bcoeff = beta)

}
