% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking_data.R
\name{agrupar_edad}
\alias{agrupar_edad}
\title{Agrupar por edad y casos}
\usage{
agrupar_edad(
  data_event,
  col_edad = "edad",
  interval_edad = 10,
  porcentaje = FALSE
)
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de la enfermedad
o evento.}

\item{col_edad}{Un `character` (cadena de caracteres) con el nombre
de la columna que contiene las edades en los datos de la enfermedad o
evento; su valor por defecto es `"edad"`.}

\item{interval_edad}{Un `numeric` (numérico) que contiene el intervalo del
rango de edades; su valor por defecto es `10`.}

\item{porcentaje}{Un `logical` (TRUE o FALSE) que indica si se debe
agregar una columna con el porcentaje de casos; su valor por
defecto es `FALSE`.}
}
\value{
Un `data.frame` con los datos de la enfermedad o evento agrupados
por edad y número de casos.
}
\description{
Función que agrupa los datos de una enfermedad o evento por
edad y número de casos.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
agrupar_edad(
  data_event = data_limpia,
  col_edad = "edad",
  porcentaje = FALSE
)
}
