% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OnewayMANOVA.R
\name{OnewayMANOVA}
\alias{OnewayMANOVA}
\title{Tests in One-way MANOVA with extra information}
\usage{
OnewayMANOVA(x, group)
}
\arguments{
\item{x}{A data frame with one factor and \emph{p} response variables.}

\item{group}{Factor defining groups. It must be one of the columns
in \code{x}.}
}
\value{
Returns an object of class \code{"OnewayMANOVA"}, a list containing
the following components:
\tabular{llllllllll}{
\code{ name} \tab A character string describing the function. \cr
\code{T} \tab The total sum of squares and cross-product matrix, defined
as \eqn{\mathbf{T} = \mathbf{B} + \mathbf{W}}, with \eqn{\mathbf{B}} and
\eqn{\mathbf{W}} described below. \cr
\code{W} \tab The within-sample or residual sum of squares and
cross-product matrix. \cr
\code{B} \tab The between-sample sum of squares and cross-product matrix
\cr
\code{x.mnv} \tab An object of class "manova" (and some other classes)
produced by function \code{manova}, to be passed as argument in
\code{summary.OnewayMANOVA} in order to produce the approximate F-tests.
\cr
\code{group} \tab A character string specifying the name of the factor
defining groups.  \cr
\code{levels.group} \tab A vector showing the levels in factor
\code{group}. \cr
\code{data.name} \tab A character string giving the name of the data. \cr
\code{variables} \tab A character string vector containing the variable
names.  \cr
\code{data} \tab The data frame analyzed.  \cr
}
}
\description{
An R function to test the difference of mean vectors among the levels of a
single factor with respect to \emph{p} response variables. Sum of squares and
cross-products matrices involved in the MANOVA can be optionally displayed.
Test statistics produced are the same as those implemented in
\code{summary.manova}
}
\details{
This function is a simplified version of \code{manova}, focusing in
multivariate analysis of variance for one single factor with respect to
\emph{p} responses. The \code{print} method in \code{OnewayMANOVA} is similar
to that in \code{summary.manova}, producing the same approximate F tests in
the one-way MANOVA. A simplified printout of the sums of squares and product
matrices involved in the analysis can optionally be chosen.
}
\examples{
data(skulls)
res.MANOVA <- OnewayMANOVA(skulls, group = Period)
# Brief output
res.MANOVA

}
\references{
Manly, B.F.J., Navarro Alberto, J.A. and Gerow, K. (2024)
\emph{Multivariate Statistical Methods. A Primer}. 5th Edn.
Chapman and Hall/CRC.
}
\author{
Jorge Navarro Alberto, \email{ganava4@gmail.com}
}
