% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv.default}
\alias{cv.default}
\alias{cv}
\title{Cross-validation}
\usage{
\method{cv}{default}(
  object,
  data,
  response = NULL,
  nfolds = 5,
  rep = 1,
  weights = NULL,
  model.score = scoring,
  seed = NULL,
  shared = NULL,
  args.pred = NULL,
  args.future = list(),
  mc.cores,
  silent = FALSE,
  ...
)
}
\arguments{
\item{object}{List of \link{learner} objects}

\item{data}{data.frame or matrix}

\item{response}{Response variable (vector or name of column in \code{data}).}

\item{nfolds}{Number of folds (nfolds=0 simple test/train split into two
folds 1:([n]/2), ([n]+1/2):n with last part used for testing)}

\item{rep}{Number of repetitions (default 1)}

\item{weights}{Optional frequency weights}

\item{model.score}{Model scoring metric (default: MSE / Brier score). Must be
a function with arguments response and prediction, and may optionally
include weights, object and newdata arguments}

\item{seed}{Random seed (argument parsed to future_Apply::future_lapply)}

\item{shared}{Function applied to each fold with results send to each model}

\item{args.pred}{Optional arguments to prediction function (see details
below)}

\item{args.future}{Arguments to future.apply::future_mapply}

\item{mc.cores}{Optional number of cores. \link[parallel:mclapply]{parallel::mcmapply} used instead
of future}

\item{silent}{suppress all messages and progressbars}

\item{...}{Additional arguments parsed to elements in \code{object}}
}
\value{
An object of class '\code{cross_validated}' is returned. See
\code{\link{cross_validated-class}} for more details about this class and
its generic functions.
}
\description{
Generic cross-validation function
}
\details{
\code{object} should be list of objects of class \link{learner}.
Alternatively, each element of models should be a list with a fitting
function and a prediction function.

The \code{response} argument can optionally be a named list where the name is
then used as the name of the response argument in models. Similarly, if data
is a named list with a single data.frame/matrix then this name will be used
as the name of the data/design matrix argument in models.
}
\examples{
m <- list(learner_glm(Sepal.Length~1),
          learner_glm(Sepal.Length~Species),
          learner_glm(Sepal.Length~Species + Petal.Length))
x <- cv(m, rep=10, data=iris)
x
}
\seealso{
\link{cv.learner_sl}
}
\author{
Klaus K. Holst
}
