% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_occurrences.R
\name{count_occurrences}
\alias{count_occurrences}
\alias{summarize_occurrences}
\alias{s_count_occurrences}
\alias{a_count_occurrences}
\title{Count occurrences}
\usage{
count_occurrences(
  lyt,
  vars,
  id = "USUBJID",
  drop = TRUE,
  var_labels = vars,
  show_labels = "hidden",
  riskdiff = FALSE,
  na_str = default_na_str(),
  nested = TRUE,
  ...,
  table_names = vars,
  .stats = "count_fraction_fixed_dp",
  .stat_names = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

summarize_occurrences(
  lyt,
  var,
  id = "USUBJID",
  drop = TRUE,
  riskdiff = FALSE,
  na_str = default_na_str(),
  ...,
  .stats = "count_fraction_fixed_dp",
  .stat_names = NULL,
  .formats = NULL,
  .indent_mods = 0L,
  .labels = NULL
)

s_count_occurrences(
  df,
  .var = "MHDECOD",
  .N_col,
  .N_row,
  .df_row,
  ...,
  drop = TRUE,
  id = "USUBJID",
  denom = c("N_col", "n", "N_row")
)

a_count_occurrences(
  df,
  labelstr = "",
  ...,
  .stats = NULL,
  .stat_names = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{id}{(\code{string})\cr subject variable name.}

\item{drop}{(\code{flag})\cr whether non-appearing occurrence levels should be dropped from the resulting table.
Note that in that case the remaining occurrence levels in the table are sorted alphabetically.}

\item{var_labels}{(\code{character})\cr variable labels.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{riskdiff}{(\code{flag})\cr whether a risk difference column is present. When set to \code{TRUE}, \code{\link[=add_riskdiff]{add_riskdiff()}} must be
used as \code{split_fun} in the prior column split of the table layout, specifying which columns should be compared.
See \code{\link[=stat_propdiff_ci]{stat_propdiff_ci()}} for details on risk difference calculation.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.

Options are: \verb{'count', 'count_fraction', 'count_fraction_fixed_dp', 'fraction'}}

\item{.stat_names}{(\code{character})\cr names of the statistics that are passed directly to name single statistics
(\code{.stats}). This option is visible when producing \code{\link[rtables:data.frame_export]{rtables::as_result_df()}} with \code{make_ard = TRUE}.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var, var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.N_col}{(\code{integer(1)})\cr column-wise N (column count) for the full column being analyzed that is typically
passed by \code{rtables}.}

\item{.N_row}{(\code{integer(1)})\cr row-wise N (row group count) for the group of observations being analyzed
(i.e. with no column-based subsetting) that is typically passed by \code{rtables}.}

\item{.df_row}{(\code{data.frame})\cr data frame across all of the columns for the given row split.}

\item{denom}{(\code{string})\cr choice of denominator for proportion. Options are:
\itemize{
\item \code{N_col}: total number of patients in this column across rows.
\item \code{n}: number of patients with any occurrences.
\item \code{N_row}: total number of patients in this row across columns.
}}

\item{labelstr}{(\code{string})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}
}
\value{
\itemize{
\item \code{count_occurrences()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_occurrences()} to the table layout.
}

\itemize{
\item \code{summarize_occurrences()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted content rows
containing the statistics from \code{s_count_occurrences()} to the table layout.
}

\itemize{
\item \code{s_count_occurrences()} returns a list with:
\itemize{
\item \code{count}: list of counts with one element per occurrence.
\item \code{count_fraction}: list of counts and fractions with one element per occurrence.
\item \code{fraction}: list of numerators and denominators with one element per occurrence.
}
}

\itemize{
\item \code{a_count_occurrences()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=count_occurrences]{count_occurrences()}} creates a layout element to calculate occurrence counts for patients.

This function analyzes the variable(s) supplied to \code{vars} and returns a table of occurrence counts for
each unique value (or level) of the variable(s). This variable (or variables) must be
non-numeric. The \code{id} variable is used to indicate unique subject identifiers (defaults to \code{USUBJID}).

If there are multiple occurrences of the same value recorded for a patient, the value is only counted once.

The summarize function \code{\link[=summarize_occurrences]{summarize_occurrences()}} performs the same function as \code{\link[=count_occurrences]{count_occurrences()}} except it
creates content rows, not data rows, to summarize the current table row/column context and operates on the level of
the latest row split or the root of the table if no row splits have occurred.
}
\section{Functions}{
\itemize{
\item \code{count_occurrences()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{summarize_occurrences()}: Layout-creating function which can take content function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}.

\item \code{s_count_occurrences()}: Statistics function which counts number of patients that report an
occurrence.

\item \code{a_count_occurrences()}: Formatted analysis function which is used as \code{afun}
in \code{count_occurrences()}.

}}
\note{
By default, occurrences which don't appear in a given row split are dropped from the table and
the occurrences in the table are sorted alphabetically per row split. Therefore, the corresponding layout
needs to use \code{split_fun = drop_split_levels} in the \code{split_rows_by} calls. Use \code{drop = FALSE} if you would
like to show all occurrences.
}
\examples{
library(dplyr)
df <- data.frame(
  USUBJID = as.character(c(
    1, 1, 2, 4, 4, 4,
    6, 6, 6, 7, 7, 8
  )),
  MHDECOD = c(
    "MH1", "MH2", "MH1", "MH1", "MH1", "MH3",
    "MH2", "MH2", "MH3", "MH1", "MH2", "MH4"
  ),
  ARM = rep(c("A", "B"), each = 6),
  SEX = c("F", "F", "M", "M", "M", "M", "F", "F", "F", "M", "M", "F")
)
df_adsl <- df \%>\%
  select(USUBJID, ARM) \%>\%
  unique()

# Create table layout
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_colcounts() \%>\%
  count_occurrences(vars = "MHDECOD", .stats = c("count_fraction"))

# Apply table layout to data and produce `rtable` object
tbl <- lyt \%>\%
  build_table(df, alt_counts_df = df_adsl) \%>\%
  prune_table()

tbl

# Layout creating function with custom format.
basic_table() \%>\%
  add_colcounts() \%>\%
  split_rows_by("SEX", child_labels = "visible") \%>\%
  summarize_occurrences(
    var = "MHDECOD",
    .formats = c("count_fraction" = "xx.xx (xx.xx\%)")
  ) \%>\%
  build_table(df, alt_counts_df = df_adsl)

# Count unique occurrences per subject.
s_count_occurrences(
  df,
  .N_col = 4L,
  .N_row = 4L,
  .df_row = df,
  .var = "MHDECOD",
  id = "USUBJID"
)

a_count_occurrences(
  df,
  .N_col = 4L,
  .df_row = df,
  .var = "MHDECOD",
  id = "USUBJID"
)

}
