% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_analysis.R
\name{param_plot}
\alias{param_plot}
\title{Plot temporal de um parametro (com filtro por rio e/ou ponto)}
\usage{
param_plot(
  df,
  parametro,
  rios = NULL,
  pontos = NULL,
  add_trend = TRUE,
  facet = FALSE
)
}
\arguments{
\item{df}{Data frame com \code{data} e a coluna do \code{parametro}. Idealmente contem
\code{ponto}, e opcionalmente \code{rio}.}

\item{parametro}{Character; nome do parametro.}

\item{rios}{Vetor de nomes de rio a filtrar (opcional; usa coluna \code{rio} se existir).}

\item{pontos}{Vetor de pontos a filtrar (opcional; usa coluna \code{ponto} se existir).}

\item{add_trend}{Logical; se \code{TRUE}, adiciona \code{geom_smooth(method = "lm", se = FALSE)}.}

\item{facet}{Logical; se \code{TRUE} e houver \code{ponto}, aplica \code{facet_wrap(~ponto)}.}
}
\value{
Objeto \code{ggplot}.
}
\description{
Gera grafico temporal para \strong{um parametro}, com opcoes de filtro por \code{rios}
e/ou \code{pontos}. Se houver mais de um ponto, a cor diferencia pontos; opcional
\code{facet = TRUE} para facetar por ponto. Pode adicionar reta de tendencia com
\code{add_trend = TRUE} (lm).
}
\examples{
\dontrun{
data("wq_demo", package = "tikatuwq")
param_plot(wq_demo, "turbidez", pontos = c("P1","P2"), add_trend = TRUE, facet = TRUE)
}
}
\seealso{
Other parameter-tools: 
\code{\link{param_plot_multi}()},
\code{\link{param_summary}()},
\code{\link{param_summary_multi}()},
\code{\link{param_trend}()},
\code{\link{param_trend_multi}()}
}
\concept{parameter-tools}
