% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{prMoveData}
\alias{prMoveData}
\alias{prDeleteData}
\title{Move and delete data files.}
\usage{
prMoveData(name, newDir, subdir = ".")

prDeleteData(name, subdir = ".")
}
\arguments{
\item{name}{Name of the data file one want to move or delete (without extension)}

\item{newDir}{Subdirectory where to move a data file}

\item{subdir}{Subdirectory of the data file. It can also be indicated directly in the 
\code{name} parameter.}
}
\description{
The functions can be used to programmatically move or delete data files.
}
\examples{
projectPath <- file.path(tempdir(), "test")
prInit(projectPath)

x <- rnorm(100)

prSave(x)
list.files(projectPath, recursive = TRUE, include.dirs = TRUE)

prMoveData(x, "testdir")
list.files(projectPath, recursive = TRUE, include.dirs = TRUE)

prDeleteData("testdir/x")
list.files(projectPath, recursive = TRUE, include.dirs = TRUE)

}
\seealso{
\code{\link{prScript}}
}
