% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trafo_lm.R
\name{trafo_lm}
\alias{trafo_lm}
\title{Fits transformed linear models}
\usage{
trafo_lm(object, trafo = "boxcox", lambda = "estim", method = "ml",
  lambdarange = NULL, std = FALSE, custom_trafo = NULL)
}
\arguments{
\item{object}{an object of type \code{lm}.}

\item{trafo}{a character string. Different transformations can be used 
for transforming the dependent variable in a linear model: 
(i)  "bickeldoksum", (ii) "boxcox", (iii) "dual", 
(iv) "glog", (v) "gpower", (vi) "log", (vii) "logshiftopt", (viii) "manly", 
(ix) "modulus", (x) "neglog", (xi) "reciprocal", (xii) "yeojohnson".
Defaults to "boxcox".}

\item{lambda}{either a character named "estim" if the optimal transformation
parameter should be estimated or a numeric value determining a given value 
for the transformation parameter. Defaults to "estim".}

\item{method}{a character string. Different estimation methods can be used 
for the estimation of the optimal transformation parameter: 
(i) Maximum likelihood approach ("ml"), (ii) Skewness minimization ("skew"),
(iii) Kurtosis optimization ("kurt"), (iv) Divergence minimization by 
Kolmogorov-Smirnov ("div.ks"), by Cramer-von-Mises ("div.cvm") or by 
Kullback-Leibler ("div.kl"). Defaults to "ml".}

\item{lambdarange}{a numeric vector with two elements defining an interval 
that is used for the estimation of the optimal transformation parameter. 
Defaults to \code{NULL} which means that the default value of the chosen 
transformation is used.}

\item{std}{logical. If \code{TRUE}, the transformed model is returned based 
on the standardized/scaled transformation. Defaults to \code{FALSE}.}

\item{custom_trafo}{a list. The list has two elements where the first element 
is a function specifying the desired transformation and the second element is 
a function specifying the corresponding standardized transformation. 
Defaults to \code{NULL}.}
}
\value{
An object of class \code{trafo_lm}. Methods such as 
\code{\link{diagnostics.trafo_lm}}, \code{\link{print.trafo_lm}},
\code{\link{plot.trafo_lm}} and \code{\link{summary.trafo_lm}} can 
be used for this class.
}
\description{
Function \code{trafo_lm} fits linear models with transformed dependent 
variable. The main return are two \code{lm} objects where one is the 
untransformed linear model and the other one the transformed linear model.
}
\examples{
# Load data
data("cars", package = "datasets")

# Fit linear model
lm_cars <- lm(dist ~ speed, data = cars)

# Compare untransformed and transformed model
trafo_lm(object = lm_cars, trafo = "bickeldoksum", method = "skew", 
lambdarange = c(1e-11, 2))
}
\seealso{
\code{\link{bickeldoksum}}, \code{\link{boxcox}}, \code{\link{dual}}, 
\code{\link{glog}}, \code{\link{gpower}}, \code{\link{log}}, 
\code{\link{logshiftopt}}, \code{\link{manly}}, \code{\link{modulus}}, 
\code{\link{neglog}}, \code{\link{sqrtshift}}, \code{\link{yeojohnson}}
}
