% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_est.R
\name{residual_est}
\alias{residual_est}
\title{Residual estimation of calibration}
\usage{
residual_est(Y, X, weight, q, dataset = NULL, checking = TRUE)
}
\arguments{
\item{Y}{Matrix of the variable of interest.}

\item{X}{Matrix of the auxiliary variables for the calibration estimator. This is the matrix of the sample calibration variables.}

\item{weight}{Weight variable. One dimensional object convertible to one-column \code{data.frame}.}

\item{q}{Variable of the positive values accounting for heteroscedasticity. One dimensional object convertible to one-column \code{data.frame}.}

\item{dataset}{Optional survey data object convertible to \code{data.table}.}

\item{checking}{Optional variable if this variable is TRUE, then function checks data preparation errors, otherwise not checked. This variable by default is TRUE.}
}
\value{
A list with objects are returned by the function:
\itemize{
 \item \code{residuals} - a numeric \code{data.table} containing the estimated residuals of calibration.
 \item \code{betas} - a numeric \code{data.table} containing the estimated coefficients of calibration.
}
}
\description{
Computes the estimation residuals of calibration.
}
\details{
The function implements the following estimator:
   \deqn{e_k=Y_k-X_k^{'}B }
where
\deqn{\hat{B} = \left(\sum_{s} weight_k q_k X_k X^{'}_{k} \right)^{-1} \left(\sum_{s} weight_k q_k X_k Y_k \right)}.
}
\examples{
Y <- matrix(rchisq(10, 3), 10, 1)
X <- matrix(rchisq(20, 3), 10, 2)
w <- rep(2, 10)
q <- rep(1, 10)
residual_est(Y, X, w, q)

### Test2
Y <- matrix(rchisq(10, 3), 10, 1)
X <- matrix(c(rchisq(10, 2), rchisq(10, 2) + 10), 10, 2)
w <- rep(2, 10)
q <- rep(1, 10)
residual_est(Y, X, w, q)
as.matrix(lm(Y ~ X - 1, weights = w * q)$residuals)

}
\references{
Sixten Lundstrom and Carl-Erik Sarndal. Estimation in the presence of Nonresponse and Frame Imperfections. Statistics Sweden, 2001, p. 43-44.
}
\seealso{
\code{\link{domain}},   \code{\link{lin.ratio}},    \code{\link{linarpr}},
         \code{\link{linarpt}},  \code{\link{lingini}},      \code{\link{lingini2}},
         \code{\link{lingpg}},   \code{\link{linpoormed}},   \code{\link{linqsr}},
         \code{\link{linrmpg}},  \code{\link{vardom}},       \code{\link{vardomh}},
         \code{\link{varpoord}}, \code{\link{variance_est}}, \code{\link{variance_othstr}}
}
\keyword{survey}
