% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors-print.R
\name{print.prior}
\alias{print.prior}
\title{Prints a prior object}
\usage{
\method{print}{prior}(
  x,
  short_name = FALSE,
  parameter_names = FALSE,
  plot = FALSE,
  digits_estimates = 2,
  silent = FALSE,
  ...
)
}
\arguments{
\item{x}{a prior}

\item{short_name}{whether prior distribution names should be
shorted}

\item{parameter_names}{whether parameter names should be
printed}

\item{plot}{to return \link[base]{bquote} formatted
prior name for plotting.}

\item{digits_estimates}{number of decimals to be displayed
for printed parameters.}

\item{silent}{to silently return the print message.}

\item{...}{additional arguments}
}
\value{
\code{print.prior} invisibly returns the print statement.
}
\description{
Prints a prior object
}
\examples{
# create some prior distributions
p0 <- prior(distribution = "point",  parameters = list(location = 0))
p1 <- prior(distribution = "normal", parameters = list(mean = 0, sd = 1))

# print them
p0
p1

# use short names
print(p1, short_name = TRUE)

# print parameter names
print(p1, parameter_names = TRUE)

# generate bquote plotting syntax
plot(0, main = print(p1, plot = TRUE))

}
\seealso{
\code{\link[=prior]{prior()}}
}
