% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero_sum_normal.R
\name{bi.dist.zero_sum_normal}
\alias{bi.dist.zero_sum_normal}
\title{zero_sum_normal}
\usage{
bi.dist.zero_sum_normal(
  scale,
  event_shape,
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{scale}{A numeric vector or array representing the standard deviation of the underlying normal distribution before the zerosum constraint is enforced.}

\item{event_shape}{(numeric vector): The shape of the event, defining the dimensions of the vector that will be constrained to sum to zero.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{A logical vector or array. Optional boolean array to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector specifying the shape of the distribution. When `sample=False` (model building), this is used with `.expand(shape)` to set the distribution's batch shape. When `sample=True` (direct sampling), this is used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{An integer representing the number of batch dimensions to reinterpret as event dimensions (used in model building).}

\item{create_obj}{A logical value. If `TRUE`, returns the raw BI distribution object instead of creating a sample site. This is essential for building complex distributions like `MixtureSameFamily`.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI zero_sum_normal distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the zero_sum_normal distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
A **zero-sum normal**  is a variant of a multivariate normal in which one (or more)
linear constraint(s) force certain components to **sum to zero**.
In practice, it's used to model vectors of random effects (e.g. in hierarchical models)
where the effects are constrained to sum to zero (to avoid overparameterization or enforce identifiability).
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.zero_sum_normal(scale=0.3, event_shape = c(), sample = TRUE)
}
}
\seealso{
\url{https://num.pyro.ai/en/stable/distributions.html#zerosumnormal}
}
