% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdsubset_hdf5_dataset}
\alias{bdsubset_hdf5_dataset}
\title{Create Subset of HDF5 Dataset}
\usage{
bdsubset_hdf5_dataset(
  filename,
  dataset_path,
  indices,
  select_rows = TRUE,
  new_group = "",
  new_name = "",
  overwrite = FALSE
)
}
\arguments{
\item{filename}{Character string. Path to the HDF5 file}

\item{dataset_path}{Character string. Path to the source dataset (e.g., "/group1/dataset1")}

\item{indices}{Integer vector. Row or column indices to include (1-based, as per R convention)}

\item{select_rows}{Logical. If TRUE, selects rows; if FALSE, selects columns (default: TRUE)}

\item{new_group}{Character string. Target group for the new dataset (default: same as source)}

\item{new_name}{Character string. Name for the new dataset (default: original_name + "_subset")}

\item{overwrite}{Logical. Whether to overwrite destination if it exists (default: FALSE)}
}
\value{
Logical. TRUE on success, FALSE on failure
}
\description{
Creates a new HDF5 dataset containing only the specified rows or columns
from an existing dataset. This operation is memory efficient as it uses
HDF5's hyperslab selection for direct disk-to-disk copying without loading
the entire dataset into memory.
}
\details{
This function provides an efficient way to create subsets of large HDF5 datasets
without loading all data into memory. It uses HDF5's native hyperslab selection
mechanism for optimal performance with big data.

Key features:
\itemize{
\item Memory efficient - processes one row/column at a time
\item Direct disk-to-disk copying using HDF5 hyperslab selection
\item Preserves all dataset attributes and properties
\item Works with datasets of any size
\item Automatic creation of parent groups if needed
\item Support for both row and column selection
}
}
\section{Index Convention}{

Indices follow R's 1-based convention (first element is index 1), but are
automatically converted to HDF5's 0-based indexing internally.
}

\section{Performance}{

This function is designed for big data scenarios. Memory usage is minimal
regardless of source dataset size, making it suitable for datasets that
don't fit in memory.
}

\section{Requirements}{

\itemize{
\item The HDF5 file must exist and be accessible
\item The source dataset must exist and contain numeric data
\item Indices must be valid (within dataset dimensions)
\item User must have read-write permissions on the file
}
}

\examples{
\dontrun{
# Select specific rows (e.g., rows 1, 3, 5, 10-15)
success <- bdsubset_dataset("data.h5", 
                           dataset_path = "/matrix/data",
                           indices = c(1, 3, 5, 10:15),
                           select_rows = TRUE,
                           new_name = "selected_rows")

# Select specific columns
success <- bdsubset_dataset("data.h5",
                           dataset_path = "/matrix/data", 
                           indices = c(2, 4, 6:10),
                           select_rows = FALSE,
                           new_group = "/filtered",
                           new_name = "selected_cols")

# Create subset in different group
success <- bdsubset_dataset("data.h5",
                           dataset_path = "/raw_data/matrix",
                           indices = 1:100,  # First 100 rows
                           select_rows = TRUE,
                           new_group = "/processed",
                           new_name = "top_100_rows")

# Extract specific samples for analysis
interesting_samples <- c(15, 23, 45, 67, 89, 123)
success <- bdsubset_dataset("data.h5",
                           dataset_path = "/experiments/results",
                           indices = interesting_samples,
                           select_rows = TRUE,
                           new_name = "analysis_subset")
}

}
\seealso{
Other BigDataStatMeth HDF5 utilities: 
\code{\link{bdmove_hdf5_dataset}()}
}
\author{
BigDataStatMeth package authors
}
\concept{BigDataStatMeth HDF5 utilities}
