% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.r
\name{as_EBImage}
\alias{as_EBImage}
\title{Convert BioThermR Object to EBImage Object}
\usage{
as_EBImage(img_obj, use_processed = TRUE, replace_na = 0, normalize = FALSE)
}
\arguments{
\item{img_obj}{A 'BioThermR' object.}

\item{use_processed}{Logical. If \code{TRUE} (default), uses the 'processed' matrix (which might already have masks applied).
If \code{FALSE}, uses the 'raw' temperature matrix.}

\item{replace_na}{Numeric. The value to replace \code{NA}s with, as 'EBImage' does not support missing values.
Default is 0 (typically treated as background).}

\item{normalize}{Logical. If \code{TRUE}, scales the matrix values linearly to the range [0, 1].
This is highly recommended for visualization or standard thresholding algorithms
(like Otsu) in 'EBImage'. Default is \code{FALSE} (preserves actual temperature values).}
}
\value{
An \code{Image} object (defined in the 'EBImage' package).
}
\description{
Extracts the thermal matrix (raw or processed) from a 'BioThermR' object and
             converts it into an 'EBImage' class object. This conversion is essential for
             applying advanced morphological operations (e.g., thresholding, watershed,
             labeling) provided by the 'EBImage' package.
}
\examples{
\donttest{
# Load data
mat <- matrix(runif(160*120, 20, 40), nrow = 120, ncol = 160)
obj <- create_BioThermR(mat, name = "Simulation_01")

# Convert to EBImage format with normalization (for thresholding)
eb_norm <- as_EBImage(obj, normalize = TRUE)

# Convert preserving temperature values (for calculation)
eb_temp <- as_EBImage(obj, normalize = FALSE)
}
}
