% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.r
\name{create_BioThermR}
\alias{create_BioThermR}
\title{Create BioThermR Object from Data}
\usage{
create_BioThermR(data, name = "Sample")
}
\arguments{
\item{data}{A numeric matrix or data frame representing the thermal image grid (rows x cols).}

\item{name}{String. An identifier for this sample (e.g., filename or sample ID). Default is "Sample".}
}
\value{
A 'BioThermR' object.
}
\description{
Manually creates a BioThermR object from a numeric matrix or data frame.
             Useful for converting data loaded from other formats (Excel, CSV, txt) or simulation data.
}
\examples{
mat <- matrix(runif(160*120, 20, 40), nrow = 120, ncol = 160)
obj <- create_BioThermR(mat, name = "Simulation_01")
plot_thermal_heatmap(obj)
}
