% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.r
\name{from_EBImage}
\alias{from_EBImage}
\title{Import EBImage Object into BioThermR}
\usage{
from_EBImage(
  eb_img,
  template_obj = NULL,
  name = "Imported_EBImage",
  mask_zero = FALSE
)
}
\arguments{
\item{eb_img}{An \code{Image} object (from the 'EBImage' package).}

\item{template_obj}{Optional. An existing 'BioThermR' object to update.
Providing this ensures that original metadata (like filenames and original raw data)
is retained. Default is \code{NULL}.}

\item{name}{String. The name assigned to the new object (used only if \code{template_obj} is \code{NULL}).
Default is "Imported_EBImage".}

\item{mask_zero}{Logical. If \code{TRUE}, converts values of 0 in the imported matrix to \code{NA}.
This is particularly useful when importing binary masks where 0 represents the background,
as BioThermR uses \code{NA} to exclude background pixels from statistical calculations.
Default is \code{FALSE}.}
}
\value{
A 'BioThermR' object with the imported matrix stored in the \code{processed} slot.
}
\description{
Converts an 'EBImage' class object back into the 'BioThermR' framework.
             This function is designed to integrate results from external morphological
             operations (e.g., watershed segmentation, filtering) back into the standard
             BioThermR analytical workflow.
}
\details{
This function supports two modes:
         \itemize{
           \item \strong{Update Mode:} If \code{template_obj} is provided, the input image replaces
                 the \code{processed} matrix of the template. Metadata (filename, path) is preserved.
                 Statistics are reset to \code{NULL} as the data has changed.
           \item \strong{Create Mode:} If \code{template_obj} is \code{NULL}, a new 'BioThermR' object is created
                 from scratch using the input matrix.
         }
         If the input \code{eb_img} has more than 2 dimensions (e.g., color/RGB), only the first channel
         is utilized, and a warning is issued.
}
\examples{
\donttest{
# Load data
mat <- matrix(runif(160*120, 20, 40), nrow = 120, ncol = 160)
obj <- create_BioThermR(mat, name = "Simulation_01")

# Convert to EBImage format with normalization
eb_obj <- as_EBImage(obj, normalize = TRUE)

# Convert to BioThermR from EBImage
new_obj <- from_EBImage(eb_obj)
}
}
