% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.r
\name{read_thermal_flir}
\alias{read_thermal_flir}
\title{Read FLIR Radiometric JPG File}
\usage{
read_thermal_flir(file_path, exiftoolpath = "installed")
}
\arguments{
\item{file_path}{String. The full path to the FLIR radiometric .jpg file.}

\item{exiftoolpath}{String. Path to the ExifTool executable. Default is "installed"
(assumes it is available in the system PATH).}
}
\value{
A list object of class "BioThermR" containing:
\item{raw}{The calculated temperature matrix in degrees Celsius.}
\item{processed}{A copy of the raw matrix, intended for subsequent ROI filtering or masking.}
\item{meta}{A list containing metadata: \code{filename}, \code{fullpath}, and \code{dims}.}
}
\description{
Reads a FLIR radiometric JPG file, parses the embedded metadata (emissivity,
             distance, Planck constants, atmospheric parameters), converts the raw sensor data
             to temperature (Celsius), and constructs a 'BioThermR' object.
}
\details{
This function relies on the 'Thermimage' package and the external tool 'ExifTool'.
         It automatically extracts calibration constants (Planck R1, B, F, O, R2) and
         environmental parameters to ensure accurate physical temperature conversion.
         Please ensure 'ExifTool' is installed and added to your system PATH.
}
\examples{
\donttest{
# Example using a flir thermal file
img_obj <- system.file("extdata", "IR_2412.jpg", package = "Thermimage")
img <- read_thermal_flir(img_obj)
}
}
