% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{permute_within_strata}
\alias{permute_within_strata}
\title{Stratified permutation of x within strata}
\usage{
permute_within_strata(x, strata, seed = NULL)
}
\arguments{
\item{x}{vector to permute.}

\item{strata}{factor-like vector defining strata.}

\item{seed}{optional seed for reproducibility.}
}
\value{
x_star permuted within strata.
}
\description{
Stratified permutation of x within strata
}
\examples{
set.seed(123)
x <- 1:10
strata <- rep(letters[1:2], each = 5)
x_permuted <- permute_within_strata(x, strata, seed = 123)
}
