% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_Summary.R
\name{CST_Summary}
\alias{CST_Summary}
\title{Generate a Summary of the data and metadata in the s2dv_cube object}
\usage{
CST_Summary(data, show_loaded_files = FALSE, show_NA = FALSE, var_dim = "var")
}
\arguments{
\item{data}{An \code{s2dv_cube} object containing:
- \code{data}: N-dimensional array with named dimensions
- \code{dim}: Dimensions, including \code{var} (variables).
- \code{attrs}: Attributes such as \code{VarName} and \code{Metadata}.
- \code{coords}: Named list with coordinates of dimensions.}

\item{show_loaded_files}{A logical value indicating if the names of the 
loaded files will be displayed in the output or not. Default = FALSE.}

\item{show_NA}{A logical value indicating if details of NA values in the
loaded object will be displayed in the output or not. Default = FALSE.}

\item{var_dim}{A character string indicating the name of the variable 
dimension. Default = "var".}
}
\value{
Does not return a value. This function prints a detailed summary of 
an \code{s2dv_cube} object to the console.
}
\description{
This function prints the summary of the data and metadata of an object of 
class \code{s2dv_cube}.
}
\details{
The function uses the data and metadata from the loaded 
  \code{s2dv_cube} object to generate a summary of the object.The summary    
  includes :
  - months: Months that have been loaded.
  - range: Range of the dates that have been loaded.
  - dimensions: Object dimensions.
  - Statistical summary of the data in data: Basic statistical 
    summary of the data.
  - Variable: Loaded Variables, along with their units (units:)
  - NA-Indices per Dimension: Index with NA values per dimension
  - Number of NAs in NA-Indices per Dimensions: Number of NAs, 
    in the Indices with NA values per dimension  
  - Loaded files: Successfully loaded Files
}
\examples{
# Example 1:
CST_Summary(data = lonlat_temp_st$exp)

# Example 2:
\dontrun{
# s2dv cube paths
repos1 <- "/esarchive/exp/ecmwf/system4_m1/monthly_mean/$var$_f6h/$var$_$sdate$.nc"
repos2 <- "/esarchive/exp/ecmwf/system5_m1/monthly_mean/$var$_f6h/$var$_$sdate$.nc"

# Create data cube
data <- CST_Start(dat = list(
                  list(name = 'system4_m1', path = repos1),
                  list(name = 'system5_m1', path = repos2)),
                  var = c('tas', 'sfcWind'),
                  sdate = '20170101',
                  ensemble = indices(1),
                  time = indices(1:3),
                  lat = indices(1:5),
                  lon = indices(1:5),
                  synonims = list(lat = c('lat', 'latitude'),
                                  lon = c('lon', 'longitude')),
                  return_vars = list(time = 'sdate',
                                     longitude = 'dat',
                                     latitude = 'dat'),
                  metadata_dims = c('dat', 'var'),
                  retrieve = TRUE)

# Generate summary
CST_Summary(data)
}

}
\seealso{
\link[CSTools]{CST_Start} or \link[CSTools]{s2dv_cube} for creating
  an s2dv cube object.
}
\author{
Theertha Kariyathan, \email{theertha.kariyathan@bsc.es}
}
