% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbExecute,DatabaseConnectorJdbcConnection,character-method}
\alias{dbExecute,DatabaseConnectorJdbcConnection,character-method}
\title{Change database state}
\usage{
\S4method{dbExecute}{DatabaseConnectorJdbcConnection,character}(conn, statement, ...)
}
\arguments{
\item{conn}{A \link[DBI:DBIConnection-class]{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{statement}{a character string containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbExecute()} always returns a
scalar
numeric
that specifies the number of rows affected
by the statement.
}
\description{
Executes a statement and returns the number of rows affected.
\code{dbExecute()} comes with a default implementation
(which should work with most backends) that calls
\code{\link[DBI:dbSendStatement]{dbSendStatement()}}, then \code{\link[DBI:dbGetRowsAffected]{dbGetRowsAffected()}}, ensuring that
the result is always freed by \code{\link[DBI:dbClearResult]{dbClearResult()}}.
For passing query parameters, see \code{\link[DBI:dbBind]{dbBind()}}, in particular
the "The command execution flow" section.

}
\details{
You can also use \code{dbExecute()} to call a stored procedure
that performs data manipulation or other actions that do not return a result set.
To execute a stored procedure that returns a result set,
or a data manipulation query that also returns a result set
such as \verb{INSERT INTO ... RETURNING ...}, use \code{\link[DBI:dbGetQuery]{dbGetQuery()}} instead.
}
\seealso{
For queries: \code{\link[DBI:dbSendQuery]{dbSendQuery()}} and \code{\link[DBI:dbGetQuery]{dbGetQuery()}}.

Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbAppendTableArrow}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbCreateTableArrow}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExistsTable}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbGetQueryArrow}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbReadTableArrow}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendQueryArrow}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbUnquoteIdentifier}()},
\code{\link[DBI]{dbWriteTable}()},
\code{\link[DBI]{dbWriteTableArrow}()}

Other command execution generics: 
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbSendStatement}()}
}
