% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_trend}
\alias{plot_trend}
\title{Plots trends over time}
\usage{
plot_trend(
  input_data,
  emc,
  par_name,
  subject = 1,
  filter = NULL,
  on_x_axis = "trials",
  pp_shaded = TRUE,
  ...
)
}
\arguments{
\item{input_data}{a p_vector or posterior predictives compatible with the provided emc object}

\item{emc}{An emc object}

\item{par_name}{Parameter name (or covariate name) to plot}

\item{subject}{Subject number to plot}

\item{filter}{Optional function that takes a data frame and returns a logical vector indicating which rows to include in the plot}

\item{on_x_axis}{Column name in the \code{dadm} to plot on the x-axis. By default 'trials'.}

\item{pp_shaded}{Boolean. If \code{TRUE} will plot 95\% credible interval as a shaded area. Otherwise plots separate lines for each iteration of the posterior predictives. Only applicable if \code{input_data} are posterior predictives.}

\item{...}{Optional arguments that can be passed to \code{plots}.}
}
\value{
A trend plot
}
\description{
Plots the trend for selected parameters of a model. Can be used either with a p_vector, or trial-wise parameters or covariates obtained
from predict()
}
\examples{
dat <- EMC2:::add_trials(forstmann)
dat$trials2 <- dat$trials/1000

lin_trend <- make_trend(cov_names='trials2',
                        kernels = 'exp_incr',
                        par_names='B',
                        bases='lin',
                        phase = "premap")

design_RDM_lin_B <- design(model=RDM,
                           data=dat,
                           covariates='trials2',   # specify relevant covariate columns
                           matchfun=function(d) d$S==d$lR,
                           transform=list(func=c('B'='identity')),
                           formula=list(B ~ 1, v ~ lM, t0 ~ 1),
                           trend=lin_trend)       # add trend

emc <- make_emc(dat, design=design_RDM_lin_B, compress = FALSE)
p_vector <- c('B'=1, 'v'=1, 'v_lMTRUE'=1, 't0'=0.1, 'B.w'=1, 'B.d_ei'=1)

# Visualize trend
plot_trend(p_vector, emc=emc,
           par_name='B', subject='as1t',
           filter=function(d) d$lR=='right', main='Threshold for right')
}
