% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelsLac.R
\name{ModelsLac}
\alias{ModelsLac}
\title{Performs the model fitting and the weight assignment based on different strategies for each individual ID}
\usage{
ModelsLac(
  data,
  ID_col,
  ID,
  trait,
  dim,
  alpha,
  models,
  param_list = NULL,
  silent = silent
)
}
\arguments{
\item{data}{A data frame containing the daily milking records}

\item{ID_col}{The name of the column containing the unique IDs of the individuals}

\item{ID}{The individual ID that is being analyzed}

\item{trait}{The name of the column containing daily milking records}

\item{dim}{The name of the column containing days in milk records}

\item{alpha}{A penalization factor, ranging from 0 to 1, for the estimation of the model`s weight}

\item{models}{A vector describing the models to be included in the analysis. In total, 47 models are included in EMOTIONS. The default option is "All", which results in the inclusion of the 47 models. Alternatively, a vector containing any subset of the following models can be provided: "MMR","MME","brody23","brody24", "SCH","SCHL","PBE","wood","DHA", "CB","QP","CLD","PapBo1","PapBo2", "PapBo3", "PapBo4", "PapBo6", "GS1",  "GS2","LQ", "wil", "wilk", "wilycsml", "BC", "DJK","MG2", "MG4", "MG", "KHN", "AS", "FRP","PTmult","PTmod", "MonoG", "MonoGpw", "DiG", "DiGpw","legpol3", "legpol4", "legpolWil", "cubsplin3", "cubsplin4", "cubsplin5", "cubsplindef", "wilminkPop", "qntReg"}

\item{param_list}{A list composed by the models, named as in the models parameter, and the repective parameters included in the models.}

\item{silent}{A logical string defining if warning should be printed or not during the model fitting. The defaul is TRUE (not printing warnings).}
}
\value{
A list containing the fitted models, the model`s weigths and ranks, and the predicted daily production obtained through the model ensemble
}
\description{
Performs the model fitting and the weight assignment based on different strategies for each individual ID
}
