% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dpca.R
\name{Dpca}
\alias{Dpca}
\title{Distributed Principal Component Analysis (DPCA)}
\usage{
Dpca(data, K, nk)
}
\arguments{
\item{data}{A numeric matrix or data frame containing the data, where rows are observations and columns are variables.}

\item{K}{Integer, the number of subsets to partition the data into.}

\item{nk}{Integer, the size of each subset (number of rows per subset).}
}
\value{
A list containing:
\itemize{
  \item \code{MSEXp}: Minimum squared reconstruction error.
  \item \code{MSEvp}: MSE of eigenvectors.
  \item \code{MSESp}: MSE of covariance matrix.
  \item \code{kopt}: Optimal subset index.
}
}
\description{
Performs distributed PCA on a data matrix partitioned into subsets.
}
\details{
The function splits the input data matrix into \code{K} subsets of size \code{nk} each. 
The parameters \code{n} (number of rows) and \code{p} (number of columns) are automatically 
derived from the input data matrix as \code{n = nrow(data)} and \code{p = ncol(data)}.
}
\examples{
K <- 20
nk <- 50
nr <- 10
p <- 8
n <- K * nk
d <- 6
data <- matrix(c(rnorm((n - nr) * p, 0, 1), rpois(nr * p, 100)), ncol = p)
Dpca(data = data, K = K, nk = nk)
}
