% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag_cov.R
\name{lag_cov}
\alias{lag_cov}
\title{Generate lagged variables for one or more lags}
\usage{
lag_cov(data, name, time, lag, group = NULL, add = TRUE)
}
\arguments{
\item{data}{A \code{data.frame} containing equally spaced observations.}

\item{name}{A character vector: name of the variable (or variables) to lag.}

\item{time}{A single character string: name of the time-index variable (e.g.,
\code{"date"}).}

\item{lag}{A numeric vector of one or more positive integers. Each value is
interpreted as a 'lag' (i.e. shift the series backward by \eqn{k} observations).}

\item{group}{Optional character vector naming column(s) that define
independent time-series (e.g. regions). If \code{NULL}, the whole data set
is treated as one series.}

\item{add}{Logical. If \code{TRUE} (default) the lagged columns are appended
to \code{data}; if \code{FALSE} the function returns only the lagged
columns as a matrix.}
}
\value{
Either a data frame (when \code{add = TRUE}) containing the original
data plus the new lagged columns, or a numeric matrix of lagged values
(when \code{add = FALSE}).
}
\description{
This function creates lagged versions of one or more numeric or categorical variables
in an equally spaced time-series data set. A single call can create multiple lags
for each selected variable and, optionally, for each spatial/grouping unit.
}
\examples{

## Daily series for two micro-regions
d <- data.frame(
  date       = as.Date("2023-01-01") + 0:9,
  micro_code = rep(c("A", "B"), each = 5),
  tmin       = rnorm(10, 10, 2),
  pdsi       = rnorm(10)
)

## Create lags 1 to 3 for tmin and pdsi
lagged <- lag_cov(
  data  = d,
  name   = c("tmin", "pdsi"),
  time  = "date",
  group = "micro_code",
  lag   = c(1:3)
)

## Only lagged columns (matrix),
lag_only <- lag_cov(
  data = d, name = "tmin", time = "date",
  lag  = c(1:3), add = FALSE
)
}
