# BestGMM(M)


BestGMM <- function(all_result) {
  
  method_names <- names(all_result)
  if (is.null(method_names)) {
    method_names <- paste0("Method_", seq_along(all_result))
  }
  
  # Robustly extract BIC
  bic_all <- sapply(all_result, function(obj) {
    if (is.list(obj) && !is.null(obj$BIC)) return(as.numeric(obj$BIC)[1])
    NA_real_
  })
  names(bic_all) <- method_names
  
  if (all(is.na(bic_all))) {
    warning("BestGMM(): all models failed, returning NULL")
    return(structure(
      list(best = NULL, initial_method = NULL, BIC = bic_all),
      class = "bestfit"
    ))
  }
  
  best_index  <- which.min(bic_all)
  best_method <- method_names[best_index]
  
  structure(
    list(
      best = all_result[[best_index]],
      initial_method = best_method,
      BIC = bic_all
    ),
    class = "bestfit"
  )
}



#' @export
print.bestfit <- function(x, ...) {
  x_show <- x
  
  if (!is.null(x_show$best) && is.list(x_show$best) && !is.null(x_show$best$Z)) {
    if (is.matrix(x_show$best$Z)) {
      x_show$best$Z <- sprintf("<hidden> (%dx%d; use x$best$Z)",
                               nrow(x_show$best$Z), ncol(x_show$best$Z))
    } else {
      x_show$best$Z <- "<hidden> (use x$best$Z)"
    }
  }
  
  # print as a plain list (avoid recursion)
  class(x_show) <- setdiff(class(x_show), "bestfit")
  print(x_show)
  
  invisible(x)
}





