
#' Predict BMUs for new data from a fitted Gower-SOM object
#'
#' Uses the trained codebook and grid dimensions stored in a \code{gowersom}
#' object to compute BMUs and distances for new observations.
#'
#' @param object A \code{gowersom} fit returned by \code{gsom_Training()}.
#' @param newdata A data.frame of observations to map.
#' @param ... Not used.
#'
#' @return A data.frame as in \code{get_bmu_gower}.
#' @export
gsom_predict <- function(object, newdata, ...) {
  n_rows <- max(object$coords$row)
  n_cols <- max(object$coords$col)
  get_bmu_gower(newdata, codebook = object$weights, n_rows = n_rows, n_cols = n_cols)
}
