\name{plot_Umatrix}
\alias{plot_Umatrix}
\title{Plot the U-Matrix of a Gower-SOM}
\description{
Visualizes the U-Matrix of a trained Gower-SOM using \pkg{ggplot2}.
The U-Matrix reveals cluster boundaries and topological structures in the map.
}
\usage{
plot_Umatrix(u_matrix, fill_palette = "C")
}
\arguments{
  \item{u_matrix}{Numeric matrix as returned by \code{\link{gsom_Umatrix}} (\code{n_rows x n_cols}).}
  \item{fill_palette}{Character string, viridis option for the fill scale
    (default \code{"C"}).}
}
\value{
A \code{ggplot} object displaying the U-Matrix as a heatmap.
}
\details{
The function reshapes the U-Matrix into long format and draws a raster heatmap
with \code{geom_raster}. By default, it uses perceptually uniform viridis
palettes for improved interpretability, but the palette can be changed through
\code{fill_palette}.
}
\examples{
set.seed(1)
df <- data.frame(
  x1 = rnorm(20),
  x2 = rnorm(20),
  g  = factor(sample(letters[1:3], 20, TRUE))
)
fit <- gsom_Training(df, grid_rows = 3, grid_cols = 3,
                num_iterations = 5, batch_size = 4)
U <- gsom_Umatrix(fit$weights, n_rows = 3, n_cols = 3)
plot_Umatrix(U)
}
\seealso{\code{\link{gsom_Umatrix}}}
