# JapanAPIs - Access Japanese Data via Public APIs and Curated Datasets
# Version 0.1.1
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.


# jpn_gdp_cons_df

library(testthat)

# Test 1: Confirm the object is a data frame (not a tibble)
test_that("jpn_gdp_cons_df is a data frame", {
  expect_s3_class(jpn_gdp_cons_df, "data.frame")
  expect_false("tbl_df" %in% class(jpn_gdp_cons_df))  # Ensure it's not a tibble
})

# Test 2: Confirm it has exactly 3 columns
test_that("jpn_gdp_cons_df has 3 columns", {
  expect_equal(length(jpn_gdp_cons_df), 3)
})

# Test 3: Confirm it has exactly 30 rows
test_that("jpn_gdp_cons_df has 30 rows", {
  expect_equal(nrow(jpn_gdp_cons_df), 30)
})

# Test 4: Confirm column names are correct
test_that("jpn_gdp_cons_df has correct column names", {
  expect_named(jpn_gdp_cons_df, c("Year", "C", "Y"))
})

# Test 5: Confirm column types are correct
test_that("jpn_gdp_cons_df columns have correct types", {
  expect_type(jpn_gdp_cons_df$Year, "integer")
  expect_type(jpn_gdp_cons_df$C, "integer")
  expect_type(jpn_gdp_cons_df$Y, "integer")
})
