% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Analysis-class.R, R/Risoe.BINfileData-class.R
\name{sort_RLum}
\alias{sort_RLum}
\alias{sort_RLum,list-method}
\alias{sort_RLum,RLum.Analysis-method}
\alias{sort_RLum,Risoe.BINfileData-method}
\title{Sort data for RLum-class and Risoe.BINfileData-class objects}
\usage{
sort_RLum(object, ...)

\S4method{sort_RLum}{list}(object, ...)

\S4method{sort_RLum}{RLum.Analysis}(object, slot = NULL, info_element = NULL, decreasing = FALSE, ...)

\S4method{sort_RLum}{Risoe.BINfileData}(object, info_element, decreasing = FALSE, ...)
}
\arguments{
\item{object}{\linkS4class{RLum} or \linkS4class{Risoe.BINfileData} (\strong{required}):
S4 object of class \code{RLum.Analysis} or \code{Risoe.BINfileData}.}

\item{...}{further arguments passed to the specific class method}

\item{slot}{\link{character} (\emph{optional}): slot name to use in sorting.}

\item{info_element}{\link{character} (\emph{optional}): names of the \code{info} field
to use in sorting. The order of the names sets the sorting priority.
Regardless of available info elements, the following
elements always exist because they are calculated from the record
\code{XY_LENGTH}, \code{NCOL}, \code{X_MIN}, \code{X_MAX}, \code{Y_MIN}, \code{Y_MAX}.}

\item{decreasing}{\link{logical} (\emph{with default}): whether the sort order should
be decreasing (\code{FALSE} by default). It can be provided as a vector to control
the ordering sequence for each sorting element.}
}
\value{
An object of the same type as the input object provided.
}
\description{
The function provides a generalised access point for specific \linkS4class{RLum}
and \linkS4class{Risoe.BINfileData} objects. Depending on the input object,
the corresponding function will be selected.
}
\section{Functions}{
\itemize{
\item \code{sort_RLum(list)}: Returns a list of sorted \linkS4class{RLum} objects.

\item \code{sort_RLum(RLum.Analysis)}: Sorting of \code{RLum.Data} objects contained in this \code{RLum.Analysis} object.
At least one of \code{slot} and \code{info_element} must be provided. If both are
given, ordering by \code{slot} always takes priority over \code{info_element}.
Only the first element in each \code{slot} and each \code{info_element} is used
for sorting. Example: \code{.pid} can contain multiple values, however, only the
first is taken.
Please note that the \code{show()} method does some structuring, which may
lead to the impression that the sorting did not work.

\item \code{sort_RLum(Risoe.BINfileData)}: Sort method for \linkS4class{Risoe.BINfileData} objects.

}}
\section{Function version}{
 0.1.0
}

\examples{

## load example data
data(ExampleData.XSYG, envir = environment())
obj <- OSL.SARMeasurement$Sequence.Object[1:9]

sort_RLum(obj, slot = "recordType")
sort_RLum(obj, info_element = "curveDescripter")

data(ExampleData.XSYG, envir = environment())
sar <- OSL.SARMeasurement$Sequence.Object[1:5]
sort_RLum(sar, solt = "recordType", info_element = c("startDate"))

}
\seealso{
\linkS4class{RLum.Analysis}, \linkS4class{Risoe.BINfileData}
}
\author{
Marco Colombo, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Colombo, M., 2025. sort_RLum(): Sort data for RLum-class and Risoe.BINfileData-class objects. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
