% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MATESmain.R
\name{asy_cov}
\alias{asy_cov}
\title{Find the permutation covariance}
\usage{
asy_cov(R_list, m, n)
}
\arguments{
\item{R_list}{A list of numeric matrices with length S}

\item{m}{An integer representing the number of sample in X}

\item{n}{An integer representing the number of sample in Y}
}
\value{
A numeric matrix with row and column 2*S
}
\description{
This function takes a list of numeric matrices and uses a C++ backend to
find the permutation covariance
}
\examples{
\donttest{
# Generate simulated data
set.seed(123)
X <- matrix(rnorm(20), ncol = 2)  # 10 samples, 2 dimensions
Y <- matrix(rnorm(20), ncol = 2)  # 10 samples, 2 dimensions
Z <- rbind(X, Y)
m <- nrow(X)
n <- nrow(Y)
N <- m + n

# Compute distance and similarity matrices
D <- as.matrix(dist(Z, method = "manhattan"))
S <- max(D) - D

# Compute rank matrix (simplified NNG approach)
R <- matrix(0, N, N)
k <- 3
for(i in 1:N) {
  neighbors <- order(D[i,])[2:(k+1)]  # k nearest neighbors
  R[i, neighbors] <- 1:k
}
R <- R + t(R)

# Create list with one rank matrix
R_list <- list(R)

# Calculate permutation covariance
cov_mat <- asy_cov(R_list, m = m, n = n)
print(cov_mat)
}
}
