\name{Column-wise MLE of some discrete distributions}
\alias{coldisc.mle}

\title{
Column-wise MLE of some discrete distributions
}

\description{
Column-wise MLE of some discrete distributions.
}

\usage{
coldisc.mle(x, distr = "poisson", N = NULL, type = 1, tol = 1e-07)
}

\arguments{
\item{x}{
A numerical matrix with count data, dscrete data, integers. Each column refers to a different vector of observations of the same distribution.
}
\item{distr}{
The distribution to fit, "poisson" stands for the Poisson, "zip" for the zero-inflated Poisson,
"ztp" for the zero-truncated Poisson, "negbin" for the negative binomial, "binom" for the binomial,
"borel" for the Borel distribution, "geom" for the geometric, "logseries" for the log-series distribution, "betageom" for the beta-geometric, "betabinom" for the beta-binomial distribution,
"skellam" for the Skellam distribution, "gp" for the generalised Poisson distribution,
"gammapois" for the gamma-Poisson distribution, "cc" for the Cacoullos-Cauchy distribution, "cc0" for the Cacoullos-Cauchy distribution with zero location, "com-pois" for the Conway-Maxwell Poisson (COM-Poisson), and "zicom-pois" for the zero inflated COM-Poisson distribution.n.
}
\item{N}{
This is for the binomial and the beta binomial distribution only, a vector specifying the total number of trials. If it is NULL in the binomial, it is estimated by the data.
}
\item{type}{
This is for the geometric distribution only. Type 1 refers to the case where the
minimum is zero and type 2 for the case of the minimum being 1.
}
\item{tol}{
The tolerance level up to which the maximisation stops set to 1e-07 by default.
}
}

\details{
For each column, the same distribution is fitted and its parameter and log-likelihood are computed.
}

\value{
A matrix with two, columns. The first one contains the parameters of the distribution
and the second columns contains the log-likelihood values.
}

\references{
Lambert D. (1992). Zero-Inflated Poisson Regression, with an Application to Defects in
Manufacturing. Technometrics. 34 (1): 1--14

Johnson N. L., Kotz S. and Kemp A. W. (1992). Univariate Discrete
Distributions (2nd ed.). Wiley.

Skellam J. G. (1946) The frequency distribution of the difference between two Poisson variates belonging to different populations.
Journal of the Royal Statistical Society, series A 109/3, 26.

Nikoloulopoulos A.K. and Karlis D. (2008). On modeling count data: a comparison of some well-known discrete distributions. Journal of Statistical Computation and Simulation, 78(3): 437--457.

Papadatos N. (2022). The characteristic function of the discrete Cauchy distribution In Memory of T. Cacoullos. Journal of Statistical Theory and Practice, 16(3): 47.}

\author{
Michail Tsagris, Sofia Piperaki and Nikolaos Kontemeniotis.

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr} and Sofia Piperaki  \email{sofiapip23@gmail.com} and Nikolaos Kontemeniotis \email{kontemeniotisn@gmail.com}.
}

\seealso{
\code{\link{disc.mle} }
}

\examples{
x <- matrix(rpois(1000 * 50, 10), ncol = 50)
a <- coldisc.mle(x, distr = "poisson")
}
