% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omega_g_ss_rm.R
\name{omega_g_ss_rm}
\alias{omega_g_ss_rm}
\alias{omega.gen.SS.rm}
\title{omega^2_G (Generalized Omega Squared) for Multi-Way and Mixed ANOVA from F}
\usage{
omega_g_ss_rm(dfm, dfe, ssm, ssm2, sst, mss, j, f_value, a = 0.05, Fvalue)

omega.gen.SS.rm(dfm, dfe, ssm, ssm2, sst, mss, j, Fvalue, a = 0.05)
}
\arguments{
\item{dfm}{degrees of freedom for the model/IV/between}

\item{dfe}{degrees of freedom for the error/residual/within}

\item{ssm}{sum of squares for the MAIN model/IV/between}

\item{ssm2}{sum of squares for the OTHER model/IV/between}

\item{sst}{sum of squares total across the whole ANOVA}

\item{mss}{mean square for the subject variance}

\item{j}{number of levels in the OTHER IV}

\item{f_value}{F statistic from the output for your IV}

\item{a}{significance level}

\item{Fvalue}{Backward-compatible argument for the F statistic
(deprecated; use `f_value` instead). This argument is only used by the
wrapper function `omega.gen.SS.rm()`, which forwards `Fvalue` to the
`f_value` argument of `omega_g_ss_rm()`.}
}
\value{
\describe{
  \item{omega}{\eqn{\omega^2_G} effect size (legacy name; see
also `omega_value`)}
  \item{omegalow}{lower-level confidence interval of \eqn{\omega^2_G}
        (legacy name; see also `omega_lower_limit`)}
  \item{omegahigh}{upper-level confidence interval of \eqn{\omega^2_G}
        (legacy name; see also `omega_upper_limit`)}
  \item{dfm}{degrees of freedom for the model/IV/between
        (legacy name; see also `df_model`)}
  \item{dfe}{degrees of freedom for the error/residual/within
        (legacy name; see also `df_error`)}
  \item{F}{\eqn{F}-statistic (legacy name; see also `f_value`)}
  \item{p}{p-value (legacy name; see also `p_value`)}
  \item{estimate}{the \eqn{\omega^2_G} statistic and
        confidence interval in APA style for markdown printing}
  \item{statistic}{the \eqn{F}-statistic in APA style for markdown printing}
  \item{omega_value}{\eqn{\omega^2_G} effect size (snake_case
alias of `omega`)}
  \item{omega_lower_limit}{lower-level confidence interval of
\eqn{\omega^2_G}
        (alias of `omegalow`)}
  \item{omega_upper_limit}{upper-level confidence interval of
\eqn{\omega^2_G}
        (alias of `omegahigh`)}
  \item{df_model}{degrees of freedom for the model/IV/between
(alias of `dfm`)}
  \item{df_error}{degrees of freedom for the error/residual/within
(alias of `dfe`)}
  \item{f_value}{\eqn{F}-statistic (alias of `F`)}
  \item{p_value}{p-value (alias of `p`)}
}
}
\description{
This function displays \eqn{\omega^2_G} (generalized omega squared)
from ANOVA analyses and its non-central confidence interval based on
the \eqn{F} distribution. This formula is appropriate for multi-way
repeated-measures designs and mixed-level designs.
}
\details{
Omega squared is calculated by subtracting the product of the
degrees of freedom of the model and the mean square of the
subject variance from the sum of squares for the model.

This is divided by the value obtained after combining
the sum of squares total, sum of squares for the other
independent variable, and the mean square of the
subject variance multiplied by the number of levels
in the other model/IV/between.

\deqn{\omega^2_G = \frac{SS_M - (df_m \times MS_S)}{SS_T +
SS_{M2} + j \times MS_S}}

\href{https://www.aggieerin.com/shiny-server/tests/gosrmss.html}{Learn more on our example page.}

**Note on function and output names:** This effect size is now implemented
with the snake_case function name `omega_g_ss_rm()` to follow modern R style
guidelines. The original dotted version `omega.gen.SS.rm()` is still
available as a wrapper for backward compatibility, and both functions return
the same list. The returned object includes both the original element names
(e.g., `omega`, `omegalow`, `omegahigh`, `dfm`, `dfe`, `F`, `p`, `estimate`,
`statistic`) and newer snake_case aliases (e.g., `omega_value`,
`omega_lower_limit`, `omega_upper_limit`, `df_model`, `df_error`, `f_value`,
`p_value`). New code should prefer `omega_g_ss_rm()` and
the snake_case output names, but existing code using the older
names will continue to work.
}
\examples{

# The following example is derived from the "mix2_data"
# dataset, included in the MOTE library.

# Given previous research, we know that backward strength in free
# association tends to increase the ratings participants give when
# you ask them how many people out of 100 would say a word in
# response to a target word (like Family Feud). This result is
# tied to people’s overestimation of how well they think they know
# something, which is bad for studying. So, we gave people instructions
# on how to ignore the BSG.  Did it help? Is there an interaction
# between BSG and instructions given?

# You would calculate one partial GOS value for each F-statistic.
# Here's an example for the main effect 1 with typing in numbers.
omega_g_ss_rm(dfm = 1, dfe = 156,
          ssm = 6842.46829,
          ssm2 = 14336.07886,
          sst = sum(c(30936.498, 6842.46829,
                      14336.07886, 8657.094, 71.07608)),
          mss = 30936.498 / 156,
          j = 2, f_value = 34.503746, a = .05)

# Backwards-compatible dotted name (deprecated)
omega.gen.SS.rm(dfm = 1, dfe = 156,
                ssm = 6842.46829,
                ssm2 = 14336.07886,
                sst = sum(c(30936.498, 6842.46829,
                            14336.07886, 8657.094, 71.07608)),
                mss = 30936.498 / 156,
                j = 2, Fvalue = 34.503746, a = .05)
}
\keyword{ANOVA}
\keyword{effect}
\keyword{omega}
\keyword{size}
