% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{dosage_tbl_df}
\alias{dosage_tbl_df}
\title{Treatment Dosages Defined by EUCAST}
\format{
A tibble with 759 observations and 9 variables:
\describe{
  \item{ab}{Antimicrobial ID}
  \item{name}{Name of the antimicrobial agent}
  \item{type}{Type of dosage scheme}
  \item{dose}{Dose amount}
  \item{dose_times}{Number of doses per day}
  \item{administration}{Route of administration}
  \item{notes}{Additional clinical notes}
  \item{original_txt}{Original EUCAST dosage description}
  \item{eucast_version}{EUCAST guideline version number}
}
}
\source{
Data taken from the AMR package version 3.0.0
}
\usage{
data(dosage_tbl_df)
}
\description{
This dataset, dosage_tbl_df, is a tibble containing treatment dosage information for
antimicrobial agents as defined by EUCAST. The dosages are used to support interpretive
breakpoints in antimicrobial susceptibility testing.
}
\details{
The dataset name has been kept as 'dosage_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MedxR package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
