% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship.exp.store.R
\name{kinship.exp}
\alias{kinship.exp}
\title{Derive expected kinship}
\usage{
kinship.exp(
  population,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  depth.pedigree = 7,
  start.kinship = NULL,
  elements = NULL,
  mult = 1,
  storage.save = 1.05,
  verbose = TRUE,
  include.error = TRUE,
  elements.copy = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{depth.pedigree}{Depth of the pedigree in generations}

\item{start.kinship}{Relationship matrix of the individuals in the first considered generation}

\item{elements}{Vector of individuals from the database to include in pedigree matrix}

\item{mult}{Multiplicator of kinship matrix (default: 1; set to 2 for a pedigree relationship matrix)}

\item{storage.save}{Lower numbers will lead to less memory but slightly higher computing time (default: 1.5, min: 1)}

\item{verbose}{Set to FALSE to not display any prints}

\item{include.error}{Set to FALSE to ignore/correct any errors in the pedigree}

\item{elements.copy}{Set to TRUE to automatically remove duplicated entries for individuals/database from the output matrix (default: FALSE)}
}
\value{
Pedigree-based kinship matrix for in gen/database/cohort selected individuals
}
\description{
Function to derive expected kinship
}
\examples{
data(ex_pop)
kinship <- kinship.exp(population=ex_pop, gen=2)
}
