% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Input_fcors.R
\name{fcors.value}
\alias{fcors.value}
\title{Specifies the Factor Correlation Matrix for a Model}
\usage{
fcors.value(nf, cors)
}
\arguments{
\item{nf}{An integer specifying the number of factors.}

\item{cors}{A numeric vector of correlations among the factors. Values must be between -1 and +1.}
}
\value{
The function returns the factor correlation matrix.
}
\description{
This function generates a symmetric factor correlation matrix for a Structural Equation Model. The correlations must be provided as a vector of values between -1 and +1.
The vector can be entered in either row-wise or column-wise order, but the correlations must be supplied in the correct sequence.
If the model includes only a single factor, the function should be called as: "fcors.value(nf = 1, cors = c(1))"
}
\examples{
# This example represents a three-factor CFA model
#
fcors.value(nf=3, cors=c(1,.5,.6,.5,1,.4,.6,.4,1))
}
\author{
Fatih Orcan
}
