% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{EliminIndx}
\alias{EliminIndx}
\title{Distinct values selection vector}
\usage{
EliminIndx(d, q)
}
\arguments{
\item{d}{dimension of a vector x}

\item{q}{power of the Kronecker product}
}
\value{
A vector of indexes of the distinct elements in the T-vector
}
\description{
Eliminates the duplicated/q-plicated elements in a T-vector of multivariate moments
and cumulants. Produces the same results as EliminMatr.
Note EliminIndx does not provide the same results as unique()
}
\examples{
x<-c(1,0,3)
y<-kronecker(x,kronecker(x,x))
y[EliminIndx(3,3)]
## Not the same results as
unique(y)

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section  1.3.2 Multi-Indexing, Elimination, and Duplication, p.21,(1.32)
}
\seealso{
Other Matrices and commutators: 
\code{\link{EliminMatr}()},
\code{\link{MargMomCum}()},
\code{\link{QplicIndx}()},
\code{\link{QplicMatr}()},
\code{\link{SymIndx}()},
\code{\link{SymMatr}()}
}
\concept{Matrices and commutators}
