\name{stress31}
\alias{stress31}
\title{Fatigue Life of 6061-T6 Aluminum Coupons under 31,000 psi}

\description{
Fatigue life measurements (in thousands of cycles) of 6061-T6 aluminum coupons
cut parallel to the direction of rolling and oscillated at 18 cycles per second
(cps). The dataset contains 101 observations and was originally analyzed by
Birnbaum and Saunders (1969).
}

\usage{
stress31
}

\format{
A numeric vector of length 101 representing fatigue life measurements of
aluminum coupons subjected to 31,000 psi maximum stress per cycle.
}

\value{
An object of class \code{"numeric"}.

The vector consists of 101 observed fatigue life measurements, expressed in
thousands of cycles to failure, for individual 6061-T6 aluminum coupons tested
under a maximum cyclic stress of 31,000 psi. Each value represents the number
of load cycles endured by a coupon before failure. The dataset is widely used
in reliability engineering and survival analysis to illustrate lifetime
modeling and inference based on the Birnbaum--Saunders fatigue life
distribution.
}

\details{
This dataset corresponds to the well-known Birnbaum--Saunders fatigue life
example.  
The data represent time-to-failure observations collected from aluminum coupons
tested in a controlled experimental setup.  
These data have been widely used in the literature to illustrate lifetime
modeling, particularly the Birnbaum--Saunders distribution.
}

\references{
Birnbaum, Z. W., & Saunders, S. C. (1969). Estimation for a family of life
distributions with applications to fatigue.
\emph{Journal of Applied Probability}, 6, 328--347.  
\doi{10.2307/3212004}
}

\examples{
data(stress31)

summary(stress31)

hist(
  stress31,
  main = "Fatigue Life at 31,000 psi",
  xlab = "Cycles to Failure (thousands)"
)
}

\keyword{datasets}
