\name{windshield}
\alias{windshield}
\docType{data}

\title{Service Times of Aircraft Windshields}

\description{
The \code{windshield} data set contains the service times (in years) of 63
aircraft windshields. These data have been widely used in the reliability
literature, particularly for illustrating Weibull and related lifetime models.
}

\usage{
data(windshield)
}

\format{
A numeric vector of length 63 giving the service times of aircraft windshields.
}

\value{
An object of class \code{"numeric"}.

The vector consists of 63 observed service times (in years), each corresponding
to a single aircraft windshield. Each value represents the time elapsed from
installation until failure or replacement of a windshield. The dataset is
commonly used in reliability engineering and survival analysis to model
time-to-failure behavior, study hazard rate shapes, and illustrate Weibull and
extended lifetime distributions.
}

\details{
This dataset has been extensively analyzed in the context of reliability
modeling, including Weibull models, compound lifetime models, and extended
distributions such as the Weibull--Lomax distribution. The observations
represent the time-to-failure of protective aircraft windshields and serve as a
benchmark for demonstrating statistical methods for reliability and survival
analysis.
}

\references{
Murthy, D. N. P., Xie, M., & Jiang, R. (2004). \emph{Weibull Models}. Wiley.

Blischke, W. R., & Murthy, D. N. P. (2000).
\emph{Reliability: Modeling, Prediction, and Optimization}. Wiley, New York.
}

\examples{
data(windshield)

# Basic summary of the dataset
summary(windshield)

# Histogram of service times
hist(
  windshield,
  main = "Service Times of Aircraft Windshields",
  xlab = "Service Time (years)",
  col = "lightgray",
  border = "white"
)
}

\keyword{datasets}
