% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OVL_mix.R
\name{OVL_mix}
\alias{OVL_mix}
\title{Computes the overlap coefficient (OVL) between two cumulative distribution
functions corresponding to finite mixtures of two normal distributions.}
\usage{
OVL_mix(mu1, mu2, sigma1, sigma2, pi_H, pi_D, x)
}
\arguments{
\item{mu1}{Numeric vector of length 2 containing the means of the first mixture.}

\item{mu2}{Numeric vector of length 2 containing the means of the second mixture.}

\item{sigma1}{Numeric vector of length 2 containing the standard deviations of
the first mixture.}

\item{sigma2}{Numeric vector of length 2 containing the standard deviations of
the second mixture.}

\item{pi_H}{Either a numeric scalar in [0,1] giving the mixing proportion
of the first component in the first mixture, or a numeric vector of length 2
with elements summing to 1.}

\item{pi_D}{Either a numeric scalar in [0,1] giving the mixing proportion
of the first component in the second mixture, or a numeric vector of length 2
with elements summing to 1.}

\item{x}{Numeric vector of intersection points between the two mixture
densities.}
}
\value{
A numeric value corresponding to the OVL between the two
mixture distributions.
}
\description{
Computes the overlap coefficient (OVL) between two cumulative distribution
functions corresponding to finite mixtures of two normal distributions.
}
\details{
Mixing proportions equal to 0 or 1 are allowed, in which case the corresponding
mixture reduces to a single normal distribution.
}
\keyword{internal}
