#' @export
compute.spark_cdm <- function(x, name, temporary = FALSE, overwrite = TRUE, ...) {
  src <- attr(x, "tbl_source")
  schema <- writeSchema(src)
  prefix <- writePrefix(src)
  con <- getCon(src)
  if (isFALSE(overwrite)) {
    if (name %in% sparkListTables(con = con, schema = schema, prefix = prefix)) {
      cli::cli_abort(c(
        x = "Table {.pkg {name}} already exists use `overwrite = TRUE` to overwrite."
      ))
    }
  }

  if(con_type(con) == "sparklyr"){
  computeSparklyr(x = x, name = name, temporary = temporary, overwrite = overwrite)
  } else {
  computeSparkOdbcJdbc(x = x, name = name, temporary = temporary, overwrite = overwrite)
  }

}


computeSparkOdbcJdbc <- function(x, name, temporary, overwrite){
  # check source and name
  src <- attr(x, "tbl_source")
  # get attributes
  currentName <- attr(x, "tbl_name")
  schema <- writeSchema(src)
  prefix <- writePrefix(src)
  con <- getCon(src)
  if(stringr::str_count(schema, pattern = "\\.") > 0){
    workingCatalog <- gsub("\\..*", "", schema)
    workingSchema <- gsub(".*\\.", "", schema)
    table_path_parts <- list(
        dbplyr::ident(workingCatalog),
        dbplyr::sql("."),
        dbplyr::ident(workingSchema))
    } else {
    table_path_parts <- list( dbplyr::ident(schema))
  }

  if (identical(currentName, name)) {
    if(is.null(prefix)){
    intermediate_tbl <- omopgenerics::uniqueTableName()
    } else {
    intermediate_tbl <- omopgenerics::uniqueTableName(prefix = prefix)
    }
    intermediate_query_sql <- dbplyr::build_sql("CREATE TABLE ",
                                                !!!table_path_parts,
                                   dbplyr::sql("."),
                                   dbplyr::ident(intermediate_tbl),
                                   dbplyr::sql(" USING DELTA"),
                                   " AS ", dbplyr::sql_render(x),
                                   con = con)
    executeQuery(con, intermediate_query_sql)
    x <- dplyr::tbl(con,
                    getFullName(schema = schema,
                                prefix = NULL,
                                name = intermediate_tbl)
                    )
  }

  if (isTRUE(overwrite)) {
    if (name %in% sparkListTables(con = con, schema = schema, prefix = prefix)) {
      DBI::dbRemoveTable(con,
                         name = getFullName(schema = schema,
                                            prefix = prefix,
                                            name = name))
    }
  }

  query_sql <- dbplyr::build_sql("CREATE TABLE ",
                                 !!!table_path_parts,
                                 dbplyr::sql("."),
                                 dbplyr::ident(paste0(prefix, name)),
                                 dbplyr::sql(" USING DELTA"),
                           " AS ", dbplyr::sql_render(x),
                           con = con)
  executeQuery(con, query_sql)

  dplyr::tbl(con,
             getFullName(schema = schema,
                         prefix = prefix,
                         name = name))

}

computeSparklyr <- function(x, name, temporary, overwrite){

  src <- attr(x, "tbl_source")

  currentName <- attr(x, "tbl_name")
  schema <- writeSchema(src)
  prefix <- writePrefix(src)
  con <- getCon(src)

  if (identical(currentName, name)) {
    intermediate <- omopgenerics::uniqueTableName()
    sparklyrComputeTable(con = con, query = x, schema = schema, prefix = prefix, name = intermediate)
    x <- sparkReadTable(con = con, schema = schema, prefix = prefix, name = intermediate)
    on.exit(sparkDropTable(
      con = con,
      schema = schema,
      prefix = prefix,
      name = intermediate
    ))
  }

    temp_name <- omopgenerics::uniqueTableName(prefix = "tmp_")
    sparklyrComputeTable(con = con, query = x, schema = schema, prefix = prefix, name = temp_name)
    sparkReadTable(con = con, schema = schema, prefix = prefix, name = temp_name) |>
      omopgenerics::newCdmTable(src = src, name = NA_character_)

}

sparklyrComputeTable <- function(con, query, schema, prefix, name) {
 tblName <- getWriteTableName(writeSchema = schema, prefix = prefix, name = name)
 query_sql <- dbplyr::build_sql("CREATE OR REPLACE TEMP VIEW ",
                                dbplyr::ident(paste0(prefix, name)),
                                " AS ", dbplyr::sql_render(query),
                                con = con)
 executeQuery(con, query_sql)

}

