% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B00-marCoxph.R
\name{summary.marCoxph}
\alias{summary.marCoxph}
\title{Summary Method for marCoxph Objects}
\usage{
\method{summary}{marCoxph}(object, conf_level = 0.95, round.digits = 4, style = "prints", ...)
}
\arguments{
\item{object}{A \code{marCoxph} object.}

\item{conf_level}{Confidence level for intervals. Default 0.95.}

\item{round.digits}{Number of digits for rounding displayed values. Default 4.
Only used if \code{style = "prints"}.}

\item{style}{Output style: "prints" (print formatted tables) or "returns"
(return vectors). Default "prints".}

\item{...}{Additional arguments (ignored).}
}
\value{
If \code{style = "prints"}, returns invisibly. If \code{style = "returns"},
  returns a list with:
  \item{logHR}{Named vector of log hazard ratio estimates.}
  \item{logHR_CI_lower}{Named vector of lower CI bounds on log scale.}
  \item{logHR_CI_upper}{Named vector of upper CI bounds on log scale.}
  \item{SE}{Named vector of standard errors on log scale (from variance_method).}
  \item{HR}{Named vector of hazard ratio estimates (original scale).}
  \item{HR_CI_lower}{Named vector of lower CI bounds on original scale.}
  \item{HR_CI_upper}{Named vector of upper CI bounds on original scale.}
  \item{variance_method}{Variance method used.}
  \item{conf_level}{Confidence level used.}
  \item{n_per_group}{Named vector of sample sizes per group in Cox model.}
  \item{events_per_group}{Named vector of event counts per group in Cox model.}
}
\description{
Summary Method for marCoxph Objects
}
\details{
Confidence intervals are Wald-type intervals calculated as:
\itemize{
  \item Log scale: logHR ± z_crit * SE
  \item Original scale: exp(logHR ± z_crit * SE)
}

The SE used depends on \code{variance_method} from the original \code{marCoxph} call:
\itemize{
  \item "robust": Uses \code{logHR_se_robust} from sandwich estimator.
  \item "bootstrap-full" or "bootstrap-strata": Uses \code{logHR_se_bootstrap}.
}
}
