% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/YSI.R
\name{YSI}
\alias{YSI}
\title{Yield Stability Index (YSI)}
\usage{
YSI(Gen, YN, YS)
}
\arguments{
\item{Gen}{Character vector of genotype identifiers.}

\item{YN}{Numeric vector: yield (any trait) under non-stress (normal) environment.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}
}
\value{
A data frame with columns \code{Gen}, \code{YSI}.

\deqn{YSI = \frac{YS}{YN}}
}
\description{
This function computes Yield Stability Index (YSI) using any traits (like yield) under stress and non-stress conditions. The lower values of YSI indicates greater tolerance. For more details see Bouslama and Schapaugh (1984) \url{doi:10.2135/cropsci1984.0011183X002400050026x}.
}
\examples{
out = YSI(Gen=c("G1","G2","G3"), YN=c(10,8,5), YS=c(7,5,3))
print(out)
}
\references{
Bouslama, M. and Schapaugh Jr, W.T. (1984). \url{doi:10.2135/cropsci1984.0011183X002400050026x}.
}
