% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart.R
\name{wishart}
\alias{wishart}
\alias{dwishart}
\alias{rwishart}
\title{Wishart distribution}
\usage{
dwishart(x, nu, Sigma, log = FALSE)

rwishart(n, nu, Sigma)
}
\arguments{
\item{x}{positive definite p x p matrix of evaluation points}

\item{nu}{degrees of freedom, needs to be greater than \code{p - 1}}

\item{Sigma}{scale matrix, needs to be positive definite and match the dimension of \code{x}.}

\item{log}{logical; if \code{TRUE}, densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{n}{number of random deviates to return}
}
\value{
\code{dwishart} gives the density,
\code{rwishart} generates random deviates (matrix for \code{n = 1}, array for \code{n > 1})
}
\description{
Density and random generation for the wishart distribution
}
\examples{
x <- rwishart(1, nu = 5, Sigma = diag(3))
d <- dwishart(x, nu = 5, Sigma = diag(3))
}
