% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverselog_trans.R
\name{reverselog_trans}
\alias{reverselog_trans}
\title{Reverse Log Transformation}
\usage{
reverselog_trans(base = exp(1))
}
\arguments{
\item{base}{A numeric value specifying the logarithm base. Default is the natural logarithm (\code{exp(1)}).}
}
\value{
A transformation object compatible with ggplot2 scales.
}
\description{
Creates a transformation object for a reverse log scale, which can be used in ggplot2 scales.
}
\details{
This function defines a reverse logarithmic transformation, where the transformation function is
\deqn{-\log(x, \text{base})} and the inverse function is \deqn{\text{base}^{-x}}.
It is useful for cases where a decreasing log scale is needed.
}
\examples{
library(scales)
rev_log <- reverselog_trans(10)
rev_log$trans(100)  # -2
rev_log$inverse(-2) # 100

}
