% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_by_n_function.R
\name{add_by_n}
\alias{add_by_n}
\title{Add Counts and Percentages of Missing Data by Group}
\usage{
add_by_n(data, variable, by, tbl, ...)
}
\arguments{
\item{data}{A data frame containing the dataset to analyze.}

\item{variable}{A character string specifying the target variable for which missing data statistics
will be computed.}

\item{by}{A character string specifying the grouping variable. The data will be grouped by this variable
before calculating the statistics.}

\item{tbl}{Not used in the current implementation but retained for compatibility with the \code{gtsummary} framework.}

\item{...}{Additional arguments (not used in the current implementation).}
}
\value{
A data frame in wide format, where each row represents a group (as defined by \code{by}), and columns
include statistics for the target variable (\code{variable}) in a formatted string.
}
\description{
This function calculates and summarizes the counts and percentages of missing and non-missing values
for a specified variable, grouped by another variable. It provides formatted output for integration
into summary tables.
}
\details{
The function performs the following steps:
\enumerate{
\item Groups the data by the variable specified in \code{by}.
\item Computes the number of non-missing values (\code{nb}), the number of missing values (\code{nb_NA}),
and the percentage of missing values (\code{nb_percent}) for the specified \code{variable}.
\item Renames and formats the output columns for clarity and readability.
\item Converts the data into a wide format suitable for integration into summary tables,
with calculated statistics included in formatted strings (e.g., "value (missing_count ; missing_percent\%)").
}

The output is designed for use with summary tools, such as \code{gtsummary}, to display detailed missing
data statistics alongside descriptive statistics.
}
\examples{
# Example usage:
library(dplyr)
library(tidyr)
data(mtcars)

# Add missing data statistics grouped by 'cyl'
add_by_n(
  data = mtcars,
  variable = "mpg",
  by = "cyl"
)

}
