% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_xy.R
\name{fit_xy.fuzzycoco_model}
\alias{fit_xy.fuzzycoco_model}
\title{fit the FuzzyCoco model using the dataframe interface}
\usage{
\method{fit_xy}{fuzzycoco_model}(
  object,
  x,
  y,
  engine = FUZZY_COCO_HYBRID_ENGINE,
  max_generations = object$params$global_params$max_generations,
  max_fitness = object$params$global_params$max_fitness,
  seed = object$seed,
  verbose = object$verbose,
  ...
)
}
\arguments{
\item{object}{the \emph{fuzzycoco_model} object to fit}

\item{x}{the input variables data (usually to fit) as a dataframe}

\item{y}{the output variables data (usually to fit)  as a dataframe}

\item{engine}{the fuzzy coco fit engine to use, one of \strong{rcpp} and \strong{hybrid}}

\item{max_generations}{The maximum number of iterations of the algorithm.
Each iteration produces a new generation of the rules and membership functions populations.}

\item{max_fitness}{a stop condition: the iterations stop as soon as a generated fuzzy system fitness
reaches that threshold.}

\item{seed}{the RNG seed to use (to fit the model)}

\item{verbose}{whether to be verbose}

\item{...}{
  Arguments passed on to \code{\link[=fuzzycoco_fit_df_hybrid]{fuzzycoco_fit_df_hybrid}}
  \describe{
    \item{\code{model}}{a Fuzzy Coco model as a \code{fuzzy_coco} object}
    \item{\code{progress}}{whether to display the computation progress (using progressr, if available)}
    \item{\code{until}}{function that takes an \code{engine} and returns TRUE if and only if the evolution must stop.
It is a way for the user to customize the stop conditions of the algorithm.}
  }}
}
\value{
the fit as a named list
}
\description{
N.B: the underlying C++ implementation is able to automatically set some missing parameters (NA).
The final parameters are those returned by the function, is the \code{params} slot.
}
\examples{
model <- fuzzycoco("regression", example_mtcars()$params, seed = 123)
x <- mtcars[c("mpg", "hp", "wt")]
y <- mtcars["qsec"]
fit <- fit_xy(model, x, y, progress = FALSE)
print(names(fit))

}
