% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robincar-tte.R
\name{robincar_tte}
\alias{robincar_tte}
\title{Covariate adjustment for time to event data}
\usage{
robincar_tte(
  df,
  treat_col,
  response_col,
  event_col,
  adj_method,
  car_strata_cols = NULL,
  covariate_cols = NULL,
  p_trt = 0.5,
  ref_arm = NULL,
  sparse_remove = TRUE,
  car_scheme = "simple"
)
}
\arguments{
\item{df}{A data.frame with the required columns}

\item{treat_col}{Name of column in df with treatment variable}

\item{response_col}{Name of the column in df with response variable}

\item{event_col}{Name of column in df with event indicator
(0/FALSE=no event, 1/TRUE=event)}

\item{adj_method}{Adjustment method (one of "CL", "CSL", or "coxscore")}

\item{car_strata_cols}{Names of columns in df with car_strata variables}

\item{covariate_cols}{Names of columns in df with covariate variables}

\item{p_trt}{Treatment allocation ratio for the treatment arm.}

\item{ref_arm}{Reference arm of the treatment group, defaults to NULL,
which results in using the first element of `unique(data[, treat_col])`.}

\item{sparse_remove}{Remove sparse car_strata from calculation}

\item{car_scheme}{Name of the type of covariate-adaptive randomization scheme. One of: "simple", "pocock-simon", "biased-coin", "permuted-block".}
}
\value{
For adjustment method "CL" or "CSL", see value of \link[RobinCar:robincar_linear]{RobinCar::robincar_logrank()}; for adjustment method "coxscore" see value of \link[RobinCar:robincar_coxscore]{RobinCar::robincar_coxscore()}.
}
\description{
Perform a covariate-adjusted logrank test (`adj_method="CL"`),
covariate-adjusted stratified logrank test (`adj_method="CSL"`),
or a covariate-adjusted robust Cox score test (`adj_method="coxscore"`).
}
\details{
`robincar_coxscore` and `robincar_logrank` are wrapper functions around
`robincar_tte`.
}
