% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_grob_component.R
\name{get_grob_component}
\alias{get_grob_component}
\title{get_grob_component}
\usage{
get_grob_component(a_plot = NULL, component_name = NULL)
}
\arguments{
\item{a_plot}{A required ggplot2 plot object}

\item{component_name}{A required string that sets the components name}
}
\value{
A list of grob objects
}
\description{
Function retrieves a grob component from a ggplot2 plot
 object.
}
\examples{
library(ggplot2)
library(ggplotify)
library(grid)
library(RplotterPkg)

mtcars_plot <- ggplot2::ggplot(
  data = datasets::mtcars,
) +
ggplot2::geom_point(aes(x = mpg, y = wt, color = cyl), size = 3)

legend_right <- RplotterPkg::get_grob_component(
  a_plot = mtcars_plot,
  component_name = "guide-box-right"
)

}
