% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyntaxa_api_functions.R
\name{construct_dyntaxa_table}
\alias{construct_dyntaxa_table}
\title{Construct a hierarchical taxonomy table from Dyntaxa}
\usage{
construct_dyntaxa_table(
  taxon_ids,
  subscription_key = Sys.getenv("DYNTAXA_KEY"),
  shark_output = TRUE,
  add_parents = TRUE,
  add_descendants = FALSE,
  add_descendants_rank = "genus",
  add_synonyms = TRUE,
  add_missing_taxa = FALSE,
  add_hierarchy = FALSE,
  verbose = TRUE,
  add_genus_children = deprecated(),
  recommended_only = deprecated(),
  parent_ids = deprecated()
)
}
\arguments{
\item{taxon_ids}{An integer vector containing taxon IDs for which taxonomy information is requested. These IDs should correspond to specific taxonomic entities within the Dyntaxa database.}

\item{subscription_key}{A Dyntaxa API subscription key. By default, the key
is read from the environment variable \code{DYNTAXA_KEY}.

You can provide the key in three ways:
\itemize{
\item \strong{Directly as a parameter}:
\code{construct_dyntaxa_table(238366, subscription_key = "your_key_here")}.
\item \strong{Temporarily for the session}:
\code{Sys.setenv(DYNTAXA_KEY = "your_key_here")}.
After this, you do not need to pass \code{subscription_key} to the function.
\item \strong{Permanently across sessions} by adding it to your \code{~/.Renviron} file.
Use \code{usethis::edit_r_environ()} to open the file, then add:
\code{DYNTAXA_KEY=your_key_here}.
After this, you do not need to pass \code{subscription_key} to the function.
}}

\item{shark_output}{Logical. If TRUE, the function will return a table formatted with SHARK-compatible columns. If FALSE, all available columns are returned. Default is TRUE.}

\item{add_parents}{Logical. If TRUE, the function will include parent taxa (higher ranks) for the specified taxon IDs in the output. Default is TRUE.}

\item{add_descendants}{Logical. If TRUE, the output will include descendant taxa (lower ranks) for the specified taxon IDs and the rank specified in \code{add_descendants_rank}. Default is FALSE.}

\item{add_descendants_rank}{Character string specifying the rank of descendant taxa to include. Allowed values are "kingdom", "phylum", "class", "order", "family", "genus", and "species". Default is "genus".}

\item{add_synonyms}{Logical. If TRUE, the function will include synonyms for the accepted taxa in the output. Default is TRUE.}

\item{add_missing_taxa}{Logical. If TRUE, the function will attempt to fetch missing taxa (i.e., taxa not found in the initial Dyntaxa DwC-A query, such as species complexes). Default is FALSE.}

\item{add_hierarchy}{Logical. If TRUE, the function will add a hierarchy column indicating the taxonomic relationships (e.g., parent-child) among the taxa. Default is FALSE.}

\item{verbose}{Logical. If TRUE, the function will print additional messages to provide feedback on its progress. Default is TRUE.}

\item{add_genus_children}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{add_descendants} instead.}

\item{recommended_only}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{add_synonyms} instead.}

\item{parent_ids}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{taxon_ids} instead. \code{construct_dyntaxa_table} now handles taxon IDs.}
}
\value{
A \code{tibble} representing the constructed taxonomy table.
}
\description{
This function constructs a taxonomy table based on Dyntaxa taxon IDs.
It queries the SLU Artdatabanken API (Dyntaxa) to fetch taxonomy information and organizes the data into a hierarchical table.
}
\details{
A valid Dyntaxa API subscription key is required.
You can request a free key for the "Taxonomy" service from the ArtDatabanken API portal:
\url{https://api-portal.artdatabanken.se/}

\strong{Note}: Please review the \href{https://www.slu.se/artdatabanken/rapportering-och-fynd/oppna-data-och-apier/}{API conditions}
and \href{https://api-portal.artdatabanken.se/}{register for access} before using the API. Data collected through the API
is stored at SLU Artdatabanken. Please also note that the authors of \code{SHARK4R} are not affiliated with SLU Artdatabanken.
}
\examples{
\dontrun{
# Construct Dyntaxa taxonomy table for taxon IDs 238366 and 1010380
taxon_ids <- c(238366, 1010380)
taxonomy_table <- construct_dyntaxa_table(taxon_ids, "your_subscription_key")
print(taxonomy_table)
}

}
\seealso{
\code{\link{get_worms_taxonomy_tree}} for an equivalent WoRMS function

\href{https://api-portal.artdatabanken.se/}{SLU Artdatabanken API Documentation}
}
